/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;

public class jWMGlobals {
    public static final Font STDFONT = new Font("sansserif", 0, 12);
    public static final Font BOLDFONT = new Font("sansserif", 1, 12);

    public static String getJarPath() {
        int n;
        String path = new jWMGlobals().getClass().getResource("SH.txt").getPath();
        int fileIdx = path.indexOf("file:");
        int jarIdx = path.indexOf("jar!");
        path = path.substring(fileIdx + 5, jarIdx);
        int slashIdx = path.lastIndexOf("/");
        path = path.substring(0, slashIdx);
        while ((n = path.indexOf("%")) >= 0) {
            char c = (char)Integer.parseInt(path.substring(n + 1, n + 3).toUpperCase(), 16);
            path = path.substring(0, n) + c + path.substring(n + 3, path.length());
        }
        return path;
    }

    public static File[] getAllFilesOfTypeInDirectory(String suffix, String dir) {
        int dotIndex = suffix.lastIndexOf(46);
        final String sfx = dotIndex >= 0 ? suffix.substring(dotIndex) : "." + suffix;
        return new File(dir).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(sfx);
            }
        });
    }

    public static Object[] arrayFromObject(Object o) {
        Object[] oo = new Object[]{o};
        return oo;
    }

    public static String HashSetToString(HashSet hash) {
        return jWMGlobals.HashSetToString(hash, false, false);
    }

    public static String HashSetToString(HashSet hash, boolean ars, boolean rrs) {
        return jWMGlobals.DBNodeArrayToString(hash.toArray(), ars, rrs);
    }

    public static boolean endsWithCR(StringBuffer text) {
        for (int n = text.length() - 2; n >= 0 && text.charAt(n) == '\\'; n -= 2) {
            if (text.charAt(n + 1) != 'n') continue;
            return true;
        }
        return false;
    }

    public static String DBNodeArrayToHTMLString(Object[] nodes, boolean forceCR, boolean removeCR) {
        return jWMGlobals.StringToHTMLString(jWMGlobals.DBNodeArrayToString(nodes, forceCR, removeCR));
    }

    public static String StringToHTMLString(String st) {
        int n;
        String s = new String(st);
        s.replaceAll("\\n", "<br>");
        boolean on = false;
        while ((n = s.indexOf("\\b")) >= 0) {
            s = s.replaceFirst("\\\\b", on ? "</b>" : "<b>");
            on = !on;
        }
        on = false;
        while ((n = s.indexOf("\\i")) >= 0) {
            s = s.replaceFirst("\\\\i", on ? "</i>" : "<i>");
            on = !on;
        }
        s = s.replaceAll("\\\\n", "<br>");
        return s;
    }

    public static String DBNodeArrayToString(Object[] nodes, boolean forceCR, boolean removeCR) {
        int n = nodes.length;
        StringBuffer text = new StringBuffer();
        boolean first = true;
        boolean lastCR = false;
        for (int i = 0; i < n; ++i) {
            String t;
            DBNode element = (DBNode)nodes[i];
            String name = element.getStringAttribute("name");
            if (name != null && name.length() > 0) {
                if (!first && !jWMGlobals.endsWithCR(text)) {
                    text.append(" ");
                }
                text.append("\\b");
                text.append(element.getStringAttribute("name"));
                text.append("\\b");
                first = false;
            }
            if ((t = element.getBodyText()).length() > 0) {
                if (!first && !jWMGlobals.endsWithCR(text)) {
                    text.append(" ");
                }
                text.append(t.trim());
                if (forceCR && !jWMGlobals.endsWithCR(text)) {
                    text.append("\\n");
                }
                if (removeCR && jWMGlobals.endsWithCR(text)) {
                    int m = text.lastIndexOf("\\n");
                    text.replace(m, m + 2, "");
                }
            }
            first = false;
        }
        return text.toString();
    }

    public static String nameFromFilename(String fn) {
        int ns = fn.lastIndexOf(System.getProperty("file.separator")) + 1;
        int nd = fn.lastIndexOf(".");
        if (nd < 0) {
            nd = fn.length();
        }
        return fn.substring(ns, nd);
    }
}

