/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WMTroopInstance
extends WMTroop {
    int[] choices;
    String name;
    WMTroopClass wmClass;

    public WMTroopInstance(WMTroopClass proto) {
        super(proto.army);
        this.init(proto);
    }

    public WMTroopInstance(WMTroopClass proto, DBNode node) {
        super(proto.army);
        this.init(proto);
        if (node.belongsToArmy()) {
            this.name = node.getStringAttribute("name");
            this.upgrade = Integer.parseInt(node.getStringAttribute("upgrade"));
            int i = 0;
            Enumeration e = node.getStringVectorAttribute("choices").elements();
            while (e.hasMoreElements()) {
                this.choices[i] = Integer.parseInt((String)e.nextElement());
                ++i;
            }
        } else {
            for (int i = 0; i < this.dbTroops.length; ++i) {
                if (!this.dbTroops[i].equals(node)) continue;
                this.upgrade = i;
                this.name = this.dbTroops[this.upgrade].getName();
                break;
            }
        }
    }

    public boolean isInstance() {
        return true;
    }

    int getCount() {
        int n = 0;
        Enumeration e = this.wmClass.instanceEnumeration();
        while (e.hasMoreElements()) {
            if (!this.dbTroops[this.upgrade].equals(((WMTroopInstance)e.nextElement()).getDBTroop())) continue;
            ++n;
        }
        return n;
    }

    void setCount(int n) {
        int k;
        for (k = this.getCount(); k < n; ++k) {
            this.wmClass.add(new WMTroopInstance(this.wmClass, this.dbTroops[this.upgrade]));
        }
        Enumeration e = this.wmClass.revInstanceEnumeration();
        while (k > n && e.hasMoreElements()) {
            WMTroopInstance t = (WMTroopInstance)e.nextElement();
            if (!this.dbTroops[this.upgrade].equals(t.getDBTroop())) continue;
            this.wmClass.remove(t);
            --k;
        }
        this.army.changed(-1, this.wmClass);
    }

    protected void init(WMTroopClass proto) {
        this.upgrade = 0;
        this.wmClass = proto;
        Vector u = this.wmClass.getUpgrades();
        this.dbTroops = new DBTroop[u.size() + 1];
        this.dbTroops[0] = this.wmClass.getDBTroop();
        this.name = this.dbTroops[0].getName();
        int oMax = this.dbTroops[0].getOptions().size();
        int i = 1;
        Enumeration e = u.elements();
        while (e.hasMoreElements()) {
            this.dbTroops[i] = (DBTroop)e.nextElement();
            oMax = Math.max(oMax, this.dbTroops[i++].getOptions().size());
        }
        this.choices = new int[oMax];
        for (i = 0; i < this.choices.length; ++i) {
            this.choices[i] = 0;
        }
    }

    public void addTo(Document xml, Element parent) {
        Element e = xml.createElement("WM:Unit");
        e.setAttribute("id", this.dbTroops[0].getId());
        e.setAttribute("name", this.name);
        e.setAttribute("upgrade", String.valueOf(this.upgrade));
        if (this.choices.length > 0) {
            StringBuffer o = new StringBuffer();
            for (int i = 0; i < this.choices.length; ++i) {
                o.append(this.choices[i]);
                o.append(" ");
            }
            e.setAttribute("choices", o.toString().trim());
        }
        parent.appendChild(e);
    }

    public String getName() {
        return this.name;
    }

    public int[] getChoices() {
        return this.choices;
    }

    public int getSelectedUpgradeIndex() {
        return this.upgrade;
    }

    public void setSelectedUpgradeIndex(int idx) {
        Vector vAlt = this.dbTroops[this.upgrade].getStringVectorAttribute("options");
        Vector vNeu = this.dbTroops[idx].getStringVectorAttribute("options");
        int[] cNeu = new int[this.choices.length];
        for (int i = 0; i < vNeu.size(); ++i) {
            int n;
            cNeu[i] = i >= vAlt.size() ? 0 : ((n = vAlt.indexOf(vNeu.get(i))) >= 0 ? this.choices[n] : 0);
        }
        this.choices = cNeu;
        if (this.name.equals(this.dbTroops[this.upgrade].getName())) {
            this.name = this.dbTroops[idx].getName();
        }
        this.upgrade = idx;
        this.army.changed(-1, this);
    }

    public void getBreakPoints(WMArmy.Breaker b) {
        String s = this.dbTroops[this.upgrade].getStringAttribute("break");
        if (!this.isCharacter() || s.equals("1")) {
            ++b.total;
        }
        if (s.equals("s")) {
            ++b.skm;
            if (this.dbTroops[this.upgrade].getStringAttribute("arm").equals("-")) {
                ++b.skmOnly;
            } else {
                ++b.allways;
            }
        } else if (s.equals("1")) {
            ++b.allways;
        }
    }

    public int getNumberOfVariants() {
        return 1;
    }

    public Vector getDBProfiles(int i) {
        return this.getDBProfiles();
    }

    public Vector getDBProfiles() {
        Vector<DBNode> v = new Vector<DBNode>();
        v.add(this.dbTroops[this.upgrade]);
        int i = 0;
        Enumeration e = this.dbTroops[i].getOptions().elements();
        while (e.hasMoreElements()) {
            DBNode node = ((DBOption)e.nextElement()).getChoice(this.choices[i]);
            if (node != null && node.hasProfile()) {
                v.add(node);
            }
            ++i;
        }
        return v;
    }

    public Vector getOptions(int i) {
        return this.dbTroops[this.upgrade].getOptions();
    }

    public Vector getOptions() {
        return this.dbTroops[this.upgrade].getOptions();
    }

    public HashSet getRulesSet(int i) {
        return this.getRulesSet();
    }

    public HashSet getRulesSet() {
        HashSet set = new HashSet();
        set.addAll(this.dbTroops[this.upgrade].getDBNodeVectorAttribute("rules"));
        Enumeration e = this.getSelectedOptions().elements();
        while (e.hasMoreElements()) {
            set.addAll(((DBNode)e.nextElement()).getDBNodeVectorAttribute("rules"));
        }
        return set;
    }

    public int getSelectedOptionIndex(int idx) {
        return this.choices[idx];
    }

    public void setSelectedOptionIndex(int idx, int c) {
        this.choices[idx] = c;
        this.army.changed(-1, this);
    }

    public Vector getSelectedOptions() {
        Vector<DBNode> v = new Vector<DBNode>();
        int i = 0;
        Enumeration e = this.dbTroops[this.upgrade].getOptions().elements();
        while (e.hasMoreElements()) {
            DBNode option = ((DBOption)e.nextElement()).getChoice(this.choices[i]);
            if (option != null) {
                v.add(option);
            }
            ++i;
        }
        return v;
    }

    public int getTotalCost() {
        boolean i = false;
        int cost = this.dbTroops[this.upgrade].getBasicCost();
        Enumeration e = this.getSelectedOptions().elements();
        while (e.hasMoreElements()) {
            cost += ((DBOption)e.nextElement()).getBasicCost();
        }
        return cost;
    }

    public int countIds(String s) {
        int n = 0;
        if (this.dbTroops[this.upgrade].getId().equals(s)) {
            ++n;
        }
        Enumeration e = this.getSelectedOptions().elements();
        while (e.hasMoreElements()) {
            if (!((DBNode)e.nextElement()).getId().equals(s)) continue;
            ++n;
        }
        return n;
    }
}

