/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WMArmy
extends DefaultTreeModel {
    static final int ALL = -1;
    static final int NAME = 1;
    static final int STRUCTURE = 2;
    static final int POINTS = 4;
    JTree tree;
    DBRace race;
    String name;
    String filename;
    boolean dirty;

    public WMArmy(jWM jwm) {
        super(new DefaultMutableTreeNode());
        this.tree = jwm.getTree();
        this.race = jwm.getSelectedRace();
        this.filename = null;
        this.name = this.race.getName();
        this.addWMTroopClasses(this.race.getElementsByTagName("WM:Character"));
        this.addWMTroopClasses(this.race.getElementsByTagName("WM:Unit"));
        this.populate(jwm.getKs());
        this.dirty = false;
    }

    public String getName() {
        return this.name;
    }

    public WMArmy(jWM jwm, String fn, DBArmy armyNode) {
        super(new DefaultMutableTreeNode());
        this.tree = jwm.getTree();
        this.race = jwm.getSelectedRace();
        this.filename = fn;
        this.name = armyNode.getStringAttribute("name");
        ((jWM)this.tree.getTopLevelAncestor()).setMaxPoints(armyNode.getIntAttribute("size"));
        this.addWMTroopClasses(this.race.getElementsByTagName("WM:Character"));
        this.addWMTroopClasses(this.race.getElementsByTagName("WM:Unit"));
        Enumeration e = armyNode.getUnits().elements();
        block0: while (e.hasMoreElements()) {
            DBNode unit = (DBNode)e.nextElement();
            String id = unit.getStringAttribute("id");
            Enumeration f = this.classEnumeration();
            while (f.hasMoreElements()) {
                WMTroopClass c = (WMTroopClass)f.nextElement();
                if (!c.getNodeId().equals(id)) continue;
                c.add(new WMTroopInstance(c, unit));
                continue block0;
            }
        }
        this.changed(-1);
        this.dirty = false;
    }

    public DBRace getRace() {
        return this.race;
    }

    public void addWMTroopClasses(Vector v) {
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            this.insertNodeInto(new WMTroopClass(this, (DBTroop)e.nextElement()), (MutableTreeNode)this.getRoot(), this.getChildCount(this.getRoot()));
        }
    }

    public boolean saveIfDirty() {
        if (this.isDirty()) {
            switch (JOptionPane.showConfirmDialog(this.tree.getTopLevelAncestor(), "Saves haven't been changed. Would you like to save them now ?", "Save changes: ", 1)) {
                case 1: {
                    return true;
                }
                case 0: {
                    return this.save();
                }
            }
            return false;
        }
        return true;
    }

    public boolean save() {
        if (this.filename == null) {
            return this.saveAs();
        }
        this.save("", this.filename);
        return true;
    }

    public boolean saveAs() {
        if (OpenSaveDialog.Save((Frame)this.tree.getTopLevelAncestor(), "Save army as:", this.filename == null ? this.name + ".bar" : this.filename)) {
            this.save(OpenSaveDialog.getDirectory(), OpenSaveDialog.getFile().endsWith(".bar") ? OpenSaveDialog.getFile() : OpenSaveDialog.getFile() + ".bar");
            return true;
        }
        return false;
    }

    public Enumeration classEnumeration() {
        return new ClassEnumeration(this);
    }

    public Enumeration instanceEnumeration() {
        return new InstanceEnumeration(this);
    }

    public void save(String dir, String fn) {
        if (fn == null) {
            return;
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xml = builder.newDocument();
            Element army = xml.createElement("WM:Army");
            this.name = jWMGlobals.nameFromFilename(fn);
            army.setAttribute("name", this.name);
            army.setAttribute("race", this.race.getStringAttribute("id"));
            army.setAttribute("size", String.valueOf(((jWM)this.tree.getTopLevelAncestor()).getMaxPoints()));
            xml.setXmlStandalone(true);
            xml.appendChild(army);
            Enumeration e = this.classEnumeration();
            while (e.hasMoreElements()) {
                ((WMTroopClass)e.nextElement()).addTo(xml, army);
            }
            this.filename = dir + fn;
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(xml);
            StreamResult result = new StreamResult(new File(this.filename));
            transformer.transform(source, result);
            this.changed(1);
            this.dirty = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void populate(int k) {
        Enumeration e = this.classEnumeration();
        while (e.hasMoreElements()) {
            ((WMTroopClass)e.nextElement()).populate(k);
        }
        this.changed(-1);
    }

    public void changed(int flags) {
        this.changed(flags, null);
    }

    public void changed(int flags, WMTroop expand) {
        jWM jwm = (jWM)this.tree.getTopLevelAncestor();
        if ((flags & 2) != 0) {
            if (expand != null) {
                this.nodeStructureChanged(expand);
            } else {
                this.reload();
            }
        }
        if ((flags & 1) != 0) {
            jwm.setTitle(this.name);
        }
        if (expand != null) {
            this.tree.setSelectionRow(-1);
            this.tree.setSelectionPath(new TreePath(expand.getPath()));
            this.tree.expandPath(new TreePath(expand.getPath()));
        }
        jwm.refreshCostBreakAndError();
        this.dirty = true;
    }

    public String getErrors() {
        return ((jWM)this.tree.getTopLevelAncestor()).getErrors();
    }

    public int getMaximumPoints() {
        return ((jWM)this.tree.getTopLevelAncestor()).getMaxPoints();
    }

    public int getTotalCost() {
        int cost = 0;
        Enumeration e = this.classEnumeration();
        while (e.hasMoreElements()) {
            cost += ((WMTroopClass)e.nextElement()).getTotalCost();
        }
        return cost;
    }

    public int getBreakPoints() {
        Breaker b = new Breaker();
        Enumeration e = this.classEnumeration();
        while (e.hasMoreElements()) {
            ((WMTroopClass)e.nextElement()).getBreakPoints(b);
        }
        return b.getBreakPoint();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int countIds(String s) {
        int n = 0;
        Enumeration e = this.instanceEnumeration();
        while (e.hasMoreElements()) {
            n += ((WMTroopInstance)e.nextElement()).countIds(s);
        }
        return n;
    }

    public class InstanceEnumeration
    implements Enumeration {
        WMArmy army;
        int tindex;
        int uindex;

        public InstanceEnumeration(WMArmy a) {
            this.army = a;
            this.uindex = 0;
            this.tindex = 0;
        }

        public boolean hasMoreElements() {
            while (this.tindex < this.army.getChildCount(this.army.getRoot())) {
                if (this.uindex < this.army.getChildCount(this.army.getChild(this.army.getRoot(), this.tindex))) {
                    return true;
                }
                ++this.tindex;
                this.uindex = 0;
            }
            return false;
        }

        public Object nextElement() {
            return this.army.getChild(this.army.getChild(this.army.getRoot(), this.tindex), this.uindex++);
        }
    }

    public class ClassEnumeration
    implements Enumeration {
        WMArmy army;
        int index;

        public ClassEnumeration(WMArmy a) {
            this.army = a;
            this.index = 0;
        }

        public boolean hasMoreElements() {
            return this.index < this.army.getChildCount(this.army.getRoot());
        }

        public Object nextElement() {
            return this.army.getChild(this.army.getRoot(), this.index++);
        }
    }

    public class Breaker {
        public int total = 0;
        public int allways = 0;
        public int skm = 0;
        public int skmOnly = 0;

        public int getBreakPoint() {
            if (this.skm > this.total - this.skm) {
                return (this.allways + this.skmOnly + 1) / 2;
            }
            return (this.allways + 1) / 2;
        }
    }
}

