/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UITree
extends JTree {
    public UITree(TreeSelectionListener listener) {
        this.setRootVisible(false);
        this.setToggleClickCount(100);
        this.setExpandsSelectedPaths(true);
        this.setCellRenderer(new UITreeRenderer());
        this.addMouseListener(new UITreeMouseAdapter());
        this.addTreeSelectionListener(listener);
    }

    public void setModel(TreeModel m) {
        super.setModel(m);
        this.expandPath(new TreePath(this.getModel().getRoot()));
    }

    public class UITreeMouseAdapter
    extends MouseAdapter {
        public void mouseClicked(MouseEvent e) {
            int row = UITree.this.getRowForLocation(e.getX(), e.getY());
            TreePath p = UITree.this.getPathForLocation(e.getX(), e.getY());
            if (p != null && ((e.getModifiers() & 4) != 0 || (e.getModifiers() & 0x10) != 0 && (e.getModifiers() & 2) != 0)) {
                UITree.this.setSelectionPath(p);
                WMTroop troop = (WMTroop)p.getLastPathComponent();
                Rectangle r = UITree.this.getPathBounds(p);
                UINumberMenu menu = new UINumberMenu();
                menu.select(troop.getCount(), p);
                menu.setLocation(r.getLocation());
                menu.show((JTree)e.getSource(), (int)r.getX(), (int)r.getY());
            }
        }
    }
}

