/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class UITextPane
extends JTextPane {
    int pWidth;

    public static GridBagConstraints constraints() {
        return new GridBagConstraints(-1, -1, 0, 1, 0.0, 1.0, 18, 3, new Insets(2, 2, 2, 2), 0, 0);
    }

    public UITextPane(String text) {
        this.init(text, -1);
    }

    public UITextPane(String text, int w) {
        this.init(text, w);
    }

    public void init(String text, int w) {
        this.pWidth = w;
        this.setBackground(new Color(0xF0F0F0));
        SimpleAttributeSet[] attrs = new SimpleAttributeSet[]{new SimpleAttributeSet(), new SimpleAttributeSet(), new SimpleAttributeSet(), new SimpleAttributeSet()};
        attrs[0].addAttribute(StyleConstants.CharacterConstants.Bold, new Boolean(false));
        attrs[0].addAttribute(StyleConstants.CharacterConstants.Italic, new Boolean(false));
        attrs[1].addAttribute(StyleConstants.CharacterConstants.Bold, new Boolean(true));
        attrs[1].addAttribute(StyleConstants.CharacterConstants.Italic, new Boolean(false));
        attrs[2].addAttribute(StyleConstants.CharacterConstants.Bold, new Boolean(false));
        attrs[2].addAttribute(StyleConstants.CharacterConstants.Italic, new Boolean(true));
        attrs[3].addAttribute(StyleConstants.CharacterConstants.Bold, new Boolean(true));
        attrs[3].addAttribute(StyleConstants.CharacterConstants.Italic, new Boolean(true));
        if (text.length() > 0) {
            text = text.replaceAll("\\s{2,}", " ");
            text = text.replaceAll("\\\\n", "\n");
            int idx = 0;
            int attr = 0;
            do {
                int bi = text.indexOf("\\b", idx);
                int ii = text.indexOf("\\i", idx);
                if (bi < 0 && ii < 0) {
                    this.replaceSelection(text.substring(idx, text.length()));
                    idx = -1;
                } else if (ii < 0 || bi < ii && bi > 0) {
                    this.replaceSelection(text.substring(idx, bi));
                    idx = bi + 2;
                    attr ^= 1;
                } else {
                    this.replaceSelection(text.substring(idx, ii));
                    idx = ii + 2;
                    attr ^= 2;
                }
                int p = this.getText().length();
                this.select(p, p);
                this.setCharacterAttributes(attrs[attr], true);
            } while (idx >= 0);
        }
        this.setEditable(false);
        this.setFocusable(false);
    }

    public Dimension getPreferredSize() {
        View view = this.getUI().getRootView(this);
        int w = (this.pWidth > 0 ? this.pWidth : this.getParent().getParent().getSize().width) - 5;
        view.setSize(w, 1000.0f);
        return new Dimension(w, (int)view.getPreferredSpan(1));
    }
}

