/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;

public class UIProfile
extends JPanel {
    static int[][] weight = new int[][]{{20, 5, 4, 4, 4, 4}, {20, 5, 4, 4, 4, 4, 4}};
    static String[][] header = new String[][]{{"Name", "Type", "Atk", "Rng", "Cmd", "Siz"}, {"Name", "Type", "Atk", "Rng", "Hit", "Arm", "Siz"}};
    static String[][] attributes = new String[][]{{"name", "type", "atk", "rng", "cmd", "siz"}, {"name", "type", "atk", "rng", "hit", "arm", "siz"}};
    int type;
    boolean isHeader;
    String[] text;

    public static GridBagConstraints constraints() {
        return new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 11, 2, new Insets(2, 2, 2, 6), 0, 0);
    }

    public UIProfile(boolean character, Font f) {
        this.isHeader = true;
        this.type = character ? 0 : 1;
        this.text = header[this.type];
        this.setFont(f);
        this.setMinimumSize(new Dimension(400, this.getFont().getSize() + 6));
        this.setPreferredSize(new Dimension(400, this.getFont().getSize() + 6));
    }

    public UIProfile(DBTroop troop, Font f) {
        this.isHeader = false;
        this.type = troop.isCharacter() ? 0 : 1;
        this.text = new String[attributes[this.type].length];
        for (int i = 0; i < attributes[this.type].length; ++i) {
            this.text[i] = troop.getStringAttribute(attributes[this.type][i]);
        }
        this.text[1] = this.text[1].substring(0, 3) + ".";
        this.setFont(f);
        this.setMinimumSize(new Dimension(400, this.getFont().getSize() + 6));
        this.setPreferredSize(new Dimension(400, this.getFont().getSize() + 6));
    }

    public int[] xArray() {
        int i;
        int w = 0;
        int[] x = new int[weight[this.type].length + 1];
        for (i = 0; i < weight[this.type].length; ++i) {
            w += weight[this.type][i];
        }
        x[0] = 0;
        x[x.length - 1] = this.getWidth();
        for (i = 1; i < weight[this.type].length; ++i) {
            x[i] = x[i - 1] + weight[this.type][i - 1] * this.getWidth() / w;
        }
        return x;
    }

    public void paint(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        int[] xs = this.xArray();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.isHeader) {
            g.setColor(Color.black);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            for (int i = 1; i < weight[this.type].length; ++i) {
                g.drawLine(xs[i], 0, xs[i], this.getHeight() - 1);
            }
        } else {
            g.setColor(Color.gray);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(Color.black);
        }
        int y = (this.getHeight() + this.getFont().getSize()) / 2 - 1;
        g.drawString(this.text[0], xs[0] + 4, y);
        for (int i = 1; i < weight[this.type].length; ++i) {
            int w = (int)this.getFont().getStringBounds(this.text[i], g.getFontRenderContext()).getWidth();
            g.drawString(this.text[i], (xs[i] + xs[i + 1] - w) / 2, y);
        }
    }
}

