/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class UIMainPanel
extends JPanel
implements TreeSelectionListener {
    public static GridBagConstraints constraints() {
        return new GridBagConstraints(-1, -1, 0, 0, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0);
    }

    public static GridBagConstraints nameConstraints() {
        return new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 17, 3, new Insets(2, 2, 6, 0), 0, 0);
    }

    public static GridBagConstraints ptsConstraints() {
        return new GridBagConstraints(-1, -1, 0, 1, 1.0, 0.0, 12, 2, new Insets(2, 0, 6, 6), 0, 0);
    }

    public static GridBagConstraints optionConstraints() {
        return new GridBagConstraints(-1, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 2, 4, 2), 0, 0);
    }

    public static GridBagConstraints lastOptionConstraints() {
        return new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 18, 0, new Insets(4, 2, 4, 2), 0, 0);
    }

    public static GridBagConstraints upgradeConstraints() {
        return new GridBagConstraints(-1, -1, 0, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 2, 6), 0, 0);
    }

    public static GridBagConstraints rulesConstraints() {
        return new GridBagConstraints(-1, -1, 0, 1, 0.0, 1.0, 17, 1, new Insets(4, 2, 4, 2), 0, 0);
    }

    public UIMainPanel(UITree tree) {
        super(new GridBagLayout());
        tree.addTreeSelectionListener(this);
    }

    public void valueChanged(TreeSelectionEvent event) {
        UITree tree = (UITree)event.getSource();
        TreePath path = tree.getLeadSelectionPath();
        this.removeAll();
        if (event != null && event.getNewLeadSelectionPath() != null) {
            path = event.getNewLeadSelectionPath();
        }
        if (path != null) {
            WMTroop troop = (WMTroop)path.getLastPathComponent();
            int n = troop.getNumberOfVariants();
            for (int i = 0; i < n; ++i) {
                HashSet h;
                JLabel ptsLabel = new JLabel(String.valueOf(troop.getTotalCost(i)));
                ptsLabel.setHorizontalAlignment(4);
                JComponent nameComponent = troop.isInstance() && troop.getNumberOfUpgrades() > 0 ? new UIUpgrade((WMTroopInstance)troop) : new JLabel(troop.getName(i));
                this.add((Component)nameComponent, UIMainPanel.nameConstraints());
                this.add((Component)ptsLabel, UIMainPanel.ptsConstraints());
                this.add((Component)new UIProfile(troop.isCharacter(), jWMGlobals.BOLDFONT), UIProfile.constraints());
                Enumeration e = troop.getDBProfiles(i).elements();
                while (e.hasMoreElements()) {
                    this.add((Component)new UIProfile((DBTroop)e.nextElement(), jWMGlobals.STDFONT), UIProfile.constraints());
                }
                int choice = 0;
                Enumeration e2 = troop.getOptions(i).elements();
                while (e2.hasMoreElements()) {
                    this.add((Component)UIOption.create(troop, (DBOption)e2.nextElement(), choice), (choice & 3) == 3 ? UIMainPanel.lastOptionConstraints() : UIMainPanel.optionConstraints());
                    ++choice;
                }
                if ((choice - 1 & 3) != 3) {
                    this.add((Component)new UIFiller(), UIMainPanel.lastOptionConstraints());
                }
                if ((h = troop.getRulesSet(i)).size() <= 0) continue;
                this.add((Component)new UITextPane(jWMGlobals.HashSetToString(h), 0), UITextPane.constraints());
            }
        }
        this.add((Component)new UIFiller(), UIFiller.restConstraints());
        this.invalidate();
        this.revalidate();
        this.repaint(this.getBounds());
    }
}

