/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;

public class PrintedUnit
extends JPanel {
    static int[] weight = new int[]{20, 5, 4, 4, 4, 4, 4, 4, 4, 4, 10};
    static String[] header = new String[]{"Name", "Type", "Atk", "Rng", "Hits", "Arm", "Cmd", "Siz", "Notes"};
    static String[] attributes = new String[]{"name", "type", "atk", "rng", "hit", "arm", "cmd", "siz"};
    int fontSize;
    boolean isHeader;
    Vector lines;

    static PrintedUnit header() {
        return new PrintedUnit();
    }

    public PrintedUnit() {
        this.lines = new Vector();
        this.lines.add(header);
        this.isHeader = true;
    }

    public PrintedUnit(DBTroop troop) {
        this.init(troop, "");
    }

    public PrintedUnit(DBTroop troop, String rules) {
        this.init(troop, rules);
    }

    public void init(DBTroop troop, String rules) {
        this.lines = new Vector();
        String[] t = new String[header.length];
        for (int i = 0; i < attributes.length; ++i) {
            String s = troop.getStringAttribute(attributes[i]);
            t[i] = s == null ? " " : s;
        }
        t[i] = rules;
        this.lines.add(t);
        this.isHeader = false;
    }

    public int getPrefferedHeight(int w) {
        this.fontSize = Math.max(6, w / 50);
        return this.lines.size() * this.fontSize + 3;
    }

    public int[] xArray() {
        int i;
        int w = 0;
        int[] x = new int[weight.length + 1];
        for (i = 0; i < weight.length; ++i) {
            w += weight[i];
        }
        x[0] = 0;
        x[x.length - 1] = this.getWidth();
        for (i = 1; i < weight.length; ++i) {
            x[i] = x[i - 1] + weight[i - 1] * this.getWidth() / w;
        }
        return x;
    }

    public void paint(Graphics gg) {
        Graphics2D g = (Graphics2D)gg;
        int[] x = this.xArray();
        g.setColor(Color.black);
        g.setFont(new Font("sansserif", this.isHeader ? 1 : 0, this.fontSize));
        int y = 0;
        Enumeration e = this.lines.elements();
        while (e.hasMoreElements()) {
            int i;
            String[] t = (String[])e.nextElement();
            g.drawString(t[0], x[0] + 4, y += this.fontSize);
            for (i = 1; i < header.length - 1; ++i) {
                int w = (int)this.getFont().getStringBounds(t[i], g.getFontRenderContext()).getWidth();
                g.drawString(t[i], (x[i] + x[i + 1] - w) / 2, y);
            }
            if (i >= t.length) continue;
            g.drawString(t[i], x[i] + 2, y);
        }
        if (this.isHeader) {
            g.setStroke(new BasicStroke(0.5f));
            g.drawLine(0, y + 2, this.getWidth(), y + 2);
        }
    }
}

