/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PrintedPage
extends JPanel
implements Printable {
    int y;
    int fontSize;
    Book book;
    WMArmy army;
    PageFormat format;
    boolean hasProfileHeader;

    public PrintedPage(WMArmy a, Book bo, PageFormat pf) {
        this.army = a;
        this.book = bo;
        this.format = pf;
        this.setSize((int)this.format.getImageableWidth(), (int)this.format.getImageableHeight());
        this.fontSize = Math.max(6, this.getWidth() / 50);
        this.setBackground(Color.white);
        this.hasProfileHeader = false;
        this.y = 0;
        JLabel left = new JLabel(this.army.getName() + " / " + this.army.getRace().getArmyName());
        left.setFont(new Font("sansserif", 0, this.fontSize + 2));
        Dimension d = left.getPreferredSize();
        this.add(left);
        left.setSize(d);
        left.setLocation(0, this.y);
        JLabel right = new JLabel(String.valueOf(this.army.getTotalCost()) + " of " + String.valueOf(this.army.getMaximumPoints()) + " points / Breakpoint of " + String.valueOf(this.army.getBreakPoints()));
        right.setFont(new Font("sansserif", 0, this.fontSize));
        Dimension e = right.getPreferredSize();
        this.add(right);
        right.setSize(e);
        right.setLocation(this.getWidth() - e.width, d.height - e.height);
        this.y += d.height + this.fontSize;
    }

    public void close() {
        if (this.y > 0) {
            this.book.append(this, this.format);
        }
    }

    public PrintedPage addSpace(int o) {
        if (this.y == 0) {
            return this;
        }
        this.y += o;
        if (this.y < this.getHeight()) {
            return this;
        }
        this.close();
        return new PrintedPage(this.army, this.book, this.format);
    }

    public PrintedPage addLine(UITextPane c) {
        c.setBackground(Color.white);
        c.setFont(new Font("sansserif", 0, this.fontSize));
        int h = c.getPreferredSize().height;
        if (h > this.getHeight() - this.y) {
            this.close();
            PrintedPage p = new PrintedPage(this.army, this.book, this.format);
            return p.addLine(c);
        }
        this.add(c);
        c.setSize(this.getWidth(), h);
        c.setLocation(0, this.y);
        this.y += h + 2;
        return this;
    }

    public PrintedPage addLine(PrintedUnit c) {
        int h;
        if (!this.hasProfileHeader) {
            this.hasProfileHeader = true;
            this.addLine(PrintedUnit.header());
        }
        if ((h = c.getPrefferedHeight(this.getWidth())) > this.getHeight() - this.y) {
            this.close();
            PrintedPage p = new PrintedPage(this.army, this.book, this.format);
            return p.addLine(c);
        }
        this.add(c);
        c.setSize(this.getWidth(), h);
        c.setLocation(0, this.y);
        this.y += h + 2;
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.book.getNumberOfPages()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(this.format.getImageableX(), this.format.getImageableY());
        this.print(graphics);
        return 0;
    }
}

