/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Vector;

public class HTML {
    static String[] attributes = new String[]{"name", "type", "atk", "rng", "hit", "arm", "cmd", "siz"};

    public static StringBuffer columnForAttribute(String attr, Vector profiles) {
        StringBuffer result = new StringBuffer();
        result.append(attr.equals("name") ? "<td align=\"left\">" : "<td>");
        boolean first = true;
        Enumeration e = profiles.elements();
        while (e.hasMoreElements()) {
            if (!first) {
                result.append("<br>");
            } else {
                first = false;
            }
            String s = ((DBNode)e.nextElement()).getStringAttribute(attr);
            result.append(s.length() > 0 ? s : "&nbsp;");
        }
        result.append("</td>");
        return result;
    }

    public static void print(jWM jwm) {
        WMArmy army = jwm.getArmy();
        StringBuffer html = new StringBuffer();
        html.append("<html>\n<head>\n<meta http-equiv=\"content-type\" content=\"text/html;charset=iso-8859-1\">\n<meta name=\"generator\" content=\"Brumbaer jWM\">");
        html.append("<title>" + army.getName() + "</title>");
        html.append("</head>");
        html.append("<body>");
        html.append("<b>" + army.getName() + " / " + army.getRace().getArmyName() + "</b> - " + army.getTotalCost() + " of " + army.getMaximumPoints() + " points - breakpoint : " + army.getBreakPoints() + "<br>");
        html.append("<p>");
        html.append("<table border=\"1\" cellpadding=\"2\" cellspacing=\"2\" width=\"100%\">");
        html.append("<tr align=\"center\">\t<td align=\"left\"><b>Name</b></td><td><b>Type</b></td><td><b>Atk</b></td><td><b>Rng</b></td><td><b>Hit</b></td><td><b>Arm</b></td><td><b>Cmd</b></td><td><b>Siz</b></td><td><b>Pts</b></td><td><b>Notes</b></td>");
        RulesSampler rules = new RulesSampler();
        Enumeration e = army.instanceEnumeration();
        while (e.hasMoreElements()) {
            WMTroopInstance unit = (WMTroopInstance)e.nextElement();
            String rulesString = rules.add(unit);
            Vector v = unit.getDBProfiles();
            html.append("<tr align=\"center\">");
            for (int i = 0; i < attributes.length; ++i) {
                html.append(HTML.columnForAttribute(attributes[i], v));
            }
            html.append("<td>" + unit.getTotalCost() + "</td>");
            html.append("<td>" + (rulesString.length() > 0 ? rulesString : "&nbsp;") + "</td>");
        }
        html.append("</table><br>");
        int i = 1;
        Enumeration e2 = rules.rulesEnumeration();
        while (e2.hasMoreElements()) {
            html.append("<b>*" + String.valueOf(i) + ": </b> ");
            html.append(jWMGlobals.DBNodeArrayToHTMLString(jWMGlobals.arrayFromObject(e2.nextElement()), true, false));
            ++i;
        }
        String errors = army.getErrors();
        if (errors.length() > 0) {
            html.append(jWMGlobals.StringToHTMLString("<br>\\bErrors:\\b\\n" + errors));
        }
        html.append("</p>");
        html.append("</body>");
        if (OpenSaveDialog.Save(jwm, "Save HTML as:", army.getName() + ".html")) {
            String path = OpenSaveDialog.getDirectory() + (OpenSaveDialog.getFile().endsWith(".html") ? OpenSaveDialog.getFile() : OpenSaveDialog.getFile() + ".html");
            try {
                FileWriter writer = new FileWriter(path, false);
                writer.write(html.toString(), 0, html.length());
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }
}

