/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DBNode {
    Node node;
    static /* synthetic */ Class class$DBNode;

    public static DBNode create(Node nd) {
        String s = nd.getNodeName();
        if (s.equals("WM:Race")) {
            return new DBRace(nd);
        }
        if (s.equals("WM:Unit")) {
            return new DBTroop(nd);
        }
        if (s.equals("WM:UnitUpgrade")) {
            return new DBTroop(nd);
        }
        if (s.equals("WM:Character")) {
            return new DBTroop(nd);
        }
        if (s.equals("WM:CharacterUpgrade")) {
            return new DBTroop(nd);
        }
        if (s.equals("WM:ExcOption")) {
            return new DBExcOption(nd);
        }
        if (s.equals("WM:Option")) {
            return new DBOption(nd);
        }
        if (s.equals("WM:Army")) {
            return new DBArmy(nd);
        }
        if (s.equals("WM:Limit")) {
            return new DBLimit(nd);
        }
        if (s.equals("WM:CompLimit")) {
            return new DBCompLimit(nd);
        }
        DBNode dbn = new DBNode();
        dbn.node = nd;
        return dbn;
    }

    public boolean belongsToArmy() {
        return this.node.getOwnerDocument().getDocumentElement().getNodeName().equals("WM:Army");
    }

    public boolean belongsToRace() {
        return this.node.getOwnerDocument().getDocumentElement().getNodeName().equals("WM:Race");
    }

    public boolean isOption() {
        return false;
    }

    public boolean isExcOption() {
        return false;
    }

    public boolean hasProfile() {
        return false;
    }

    public boolean equals(DBNode nd) {
        return this.node == nd.node;
    }

    public String getNodeName() {
        return this.node.getNodeName();
    }

    public String getId() {
        return this.getStringAttribute("id");
    }

    public String getName() {
        return this.getStringAttribute("name");
    }

    public String getInfo() {
        return this.getBodyText();
    }

    public int getBasicCost() {
        return this.getIntAttribute("pts");
    }

    public int getIntAttribute(String att) {
        return Integer.parseInt(this.getStringAttribute(att));
    }

    public boolean getBooleanAttribute(String att) {
        return this.getStringAttribute(att).equals("yes");
    }

    public String getStringAttribute(String att) {
        Node n = this.node.getAttributes().getNamedItem(att);
        return n == null ? "" : n.getNodeValue();
    }

    public Vector getStringVectorAttribute(String att) {
        Vector<String> v = new Vector<String>();
        Node nd = this.node.getAttributes().getNamedItem(att);
        if (nd == null) {
            return v;
        }
        String o = nd.getNodeValue();
        int i = 0;
        int n = o.length();
        while (i < n) {
            int ep = o.indexOf(32, i);
            if (ep < 0) {
                ep = n;
            }
            v.add(o.substring(i, ep));
            i = ep + 1;
        }
        return v;
    }

    public Vector getDBNodeVectorAttribute(String att) {
        Vector<DBNode> v = new Vector<DBNode>();
        Enumeration e = this.getStringVectorAttribute(att).elements();
        while (e.hasMoreElements()) {
            v.add(DBNode.create(this.node.getOwnerDocument().getElementById((String)e.nextElement())));
        }
        return v;
    }

    public String getBodyText() {
        StringBuffer result = new StringBuffer();
        for (Node n = this.node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!n.getNodeName().equals("#text")) continue;
            result.append(n.getNodeValue().trim());
        }
        return result.toString();
    }

    public Vector getElementsByTagName(String n) {
        Vector<DBNode> v = new Vector<DBNode>();
        NodeList list = ((Element)this.node).getElementsByTagName(n);
        for (int i = 0; i < list.getLength(); ++i) {
            v.add(DBNode.create(list.item(i)));
        }
        return v;
    }

    public String toString() {
        return this.getStringAttribute("name");
    }

    public String getId(int idx) {
        String t = this.getNodeName();
        if (t.equals("WM:Option") && idx == 0) {
            return "";
        }
        if (t.equals("WM:ExcOption")) {
            return ((DBNode)this.getDBNodeVectorAttribute("options").get(idx)).getId();
        }
        return this.getId();
    }

    Vector getOptions() {
        return this.getDBNodeVectorAttribute("options");
    }

    Vector getAllOptions() {
        Vector<DBNode> r = new Vector<DBNode>();
        Enumeration e = this.getDBNodeVectorAttribute("options").elements();
        while (e.hasMoreElements()) {
            DBNode node = (DBNode)e.nextElement();
            r.add(node);
            r.addAll(node.getAllOptions());
        }
        return r;
    }

    public boolean equals(Object obj) {
        if ((class$DBNode == null ? (class$DBNode = DBNode.class$("DBNode")) : class$DBNode).isInstance(obj)) {
            return this.getId().equals(((DBNode)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

