#!/bin/bash 

# Define a bunch of functions here
shadowfy() {
 AMT=$(($PPI / 36))
 convert $1 \( +clone  -background black -shadow 80x3+${AMT}+${AMT} \) +swap \
            -background none  -mosaic  $1
}

img_height() {
 echo `identify $1 | nawk '{print $3}' | nawk -Fx '{print $2}'`
}

img_width() {
 echo `identify $1 | nawk '{print $3}' | nawk -Fx '{print $1}'`
}

small_boxes() {
  SB_OUTPUT=$1
  SB_WIDTH=$2
  SB_NUM=$3
  SB_SHADOW=$4

  if [ $SB_NUM -eq 0 ] ; then
    convert -size 1x1 xc:none $SB_OUTPUT
    echo 1
  else
  SB_ROWS=$(((($PSBOX+3) * $SB_NUM) / $SB_WIDTH + 1))
  convert -density $PPI -size $(($PSBOX-2))x$(($PSBOX-2)) \
    -border 1x1 -borderColor black xc:$SBOX_COLOR tmp_small.png
  i=0
  SB_STR=""
  while [ $i -lt $SB_NUM ] ; do
     SB_STR="$SB_STR tmp_small.png"
     i=$(($i+1))
  done
  AMT=$(($PPI/100))
  montage -background none -tile x$SB_ROWS -geometry +${AMT}+${AMT} $SB_STR $SB_OUTPUT 
  echo `img_height $SB_OUTPUT`
  if [ "$SB_SHADOW" == "true" ] ; then
    shadowfy $SB_OUTPUT
  fi
  fi
}

# Given a template, create the title bar
create_title() {
T_TEMPLATE=$1
T_OUTPUT=$2
T_WIDTH=$3
T_SPECIFIER_BG=$4
T_SPECIFIER_TXT=$5

T_FACTION=`cat $T_TEMPLATE | egrep '^Faction' | cut -d: -f2-100`
T_TITLE=`cat $T_TEMPLATE | egrep '^Title' | cut -d: -f2-100`
T_TYPE=`cat $T_TEMPLATE | egrep '^Type' | cut -d: -f2-100`
T_CREW=`cat $T_TEMPLATE | egrep '^Crew' | cut -d: -f2-100`
T_CREW_TITLE=`cat $T_TEMPLATE | egrep '^CrTitle' | cut -d: -f2-100`

echo "Creating Title."
# The Specifier
convert -size $(($PLBOX-2))x$(($PLBOX-2)) -border 1x1 -borderColor black \
  xc:$OTHER_COLOR tmp_1.png
if [ "$T_SPECIFIER_BG" != "none" ] ; then
  convert $T_SPECIFIER_BG -resize ${PLBOX}x${PLBOX}\! -background none \
    tmp_sp_underlay.png
  convert tmp_1.png tmp_sp_underlay.png -composite tmp_1.png
fi
if [ "$T_SPECIFIER_TXT" != "none" ] ; then
  convert -size ${PLBOX}x${PLBOX} \
     -density $PPI -font $SPECIFIER_FONT -background none \
     -gravity center -geometry +0+3 -fill ${SPECIFIER_COLOR} \
     -pointsize ${SPECIFIER_FONT_SIZE} \
     caption:"$T_SPECIFIER_TXT" -gravity center tmp_sp_overlay.png
  convert tmp_1.png tmp_sp_overlay.png -gravity center -composite tmp_1.png
fi
# The number of crew on board
UNUSED=`small_boxes tmp_8.png $PLBOX $T_CREW false`
if [ $T_CREW -ne 0 ] ; then
  convert -density $PPI -size ${PLBOX}x -gravity north \
   -font $CREW_FONT -fill $CREW_COLOR -pointsize $CREW_FONT_SIZE  \
   -background none caption:"$T_CREW_TITLE"  tmp_2.png
  convert -background none tmp_2.png tmp_8.png -append tmp_2.png
else
  mv tmp_8.png tmp_2.png
fi

convert -density $PPI -font $FACTION_FONT -background none \
   -gravity center -fill ${FACTION_COLOR} -pointsize ${FACTION_FONT_SIZE} \
   label:"$T_FACTION" tmp_3.png
convert -density $PPI -font $TITLE_FONT -background none \
   -gravity center -fill ${TITLE_COLOR} -pointsize ${TITLE_FONT_SIZE} \
   label:"$T_TITLE" tmp_4.png

T_MAX_WIDTH=$((${T_WIDTH}-(${PLBOX}*2))) 
T_TITLE_HEIGHT=`img_height tmp_4.png`

# Check to see if we need to resize the title
if [ $T_MAX_WIDTH -lt `img_width tmp_4.png` ] ; then
  convert tmp_4.png -resize ${T_MAX_WIDTH}x${T_TITLE_HEIGHT}\! tmp_4.png
fi

convert -density $PPI -font $TYPE_FONT -background none \
   -gravity center -fill ${TYPE_COLOR} -pointsize ${TYPE_FONT_SIZE} \
   label:"$T_TYPE" tmp_5.png
convert -size ${T_WIDTH}x${PLBOX} xc:none \
   tmp_3.png -gravity north -composite \
   tmp_4.png -gravity center -composite \
   tmp_5.png -gravity south -composite \
   tmp_6.png

convert -size ${T_WIDTH}x${PLBOX} xc:none \
  tmp_1.png -gravity west -composite \
  tmp_2.png -gravity northeast -composite \
  tmp_6.png -gravity center -composite \
  $T_OUTPUT 
}

# Returns the note (or an empty string if there is no note)
total_note() {
  NT_TEMPLATE=$1
  NT_EXTRA=$2
  NT_TNOTE=`cat $NT_TEMPLATE | egrep '^Note' | cut -d: -f2-100`
  if [ -z "$NT_EXTRA" ] ; then
    NT_EXTRA="none"
  fi
  if [ -z "$NT_TNOTE" ] ; then
    NT_TNOTE="none"
  fi
  if [ "$NT_EXTRA" == "none" ] ; then
    if [ "$NT_TNOTE" == "none" ] ; then
      echo ""
    else
      echo "$NT_TNOTE"
    fi
  elif [ "$NT_TNOTE" == "none" ] ; then
    echo "$NT_EXTRA"
  else
    echo "$NT_TNOTE\n$NT_EXTRA"
  fi
}

# ImageMagick isn't dealing with newlines as well as I'd like them too!
# I think it isn't supported until after the release that I have.
img_text ()
{
  IT_OUTPUT=$1
  IT_WIDTH=$2
  IT_TEXT=$3
  IT_FONT=$4
  IT_FONT_SIZE=$5
  IT_COLOR=$6
  IT_HIGHLIGHT_FONT=$7
  IT_HIGHLIGHT_FONT_SIZE=$8
  IT_HIGHLIGHT_COLOR=$9

  # I should crop this pixel away at the end
  convert -size ${IT_WIDTH}x1 xc:none $IT_OUTPUT
  echo "$IT_TEXT" | sed -e 's/\\n/\n/g' |
  while read IT_LINE ; do
     if [ -z "$IT_LINE" ] ; then
      convert $IT_OUTPUT -background none \
       -size ${IT_WIDTH}x$((($IT_FONT_SIZE * $PPI) / 72)) xc:none -append\
       $IT_OUTPUT
     else
      IT_CTRL=`echo $IT_LINE | cut -d: -f 1`
      IT_GRAVITY="west"
      IT_F=$IT_FONT
      IT_FS=$IT_FONT_SIZE
      IT_C=$IT_COLOR
      if [ "$IT_CTRL" == "h" ] ; then
        IT_LINE=`echo $IT_LINE | cut -d: -f 2-100`
        IT_F=$IT_HIGHLIGHT_FONT
        IT_FS=$IT_HIGHLIGHT_FONT_SIZE
        IT_C=$IT_HIGHLIGHT_COLOR
      elif [ "$IT_CTRL" == "c" ] ; then
        IT_LINE=`echo $IT_LINE | cut -d: -f 2-100`
        IT_GRAVITY="center"
      elif [ "$IT_CTRL" == "hc" ] ; then
        IT_LINE=`echo $IT_LINE | cut -d: -f 2-100`
        IT_F=$IT_HIGHLIGHT_FONT
        IT_FS=$IT_HIGHLIGHT_FONT_SIZE
        IT_C=$IT_HIGHLIGHT_COLOR
        IT_GRAVITY="center"
      fi

      convert $IT_OUTPUT -size ${IT_WIDTH}x -background none \
       -gravity $IT_GRAVITY \
       -density $PPI -fill $IT_C -font $IT_F -pointsize $IT_FS \
       caption:"$IT_LINE" -append $IT_OUTPUT
     fi
  done
} 

# Given a template and extra notes, create the notes box
create_note() {
N_TEMPLATE=$1
N_OUTPUT=$2
N_WIDTH=$3
N_EXTRA=$4

N_NOTE=`total_note $N_TEMPLATE "$N_EXTRA"`

echo "Creating Note Section."

if [ -z "$N_NOTE" ] ; then
  convert -size 1x1 xc:none $N_OUTPUT
else
  img_text tmp_1.png $(($N_WIDTH-2)) "$N_NOTE" $NOTE_FONT $NOTE_FONT_SIZE $NOTE_COLOR $NOTE_HIGHLIGHT_FONT $NOTE_HIGHLIGHT_FONT_SIZE $NOTE_HIGHLIGHT_COLOR
  N_HEIGHT=`img_height tmp_1.png`
  convert -density $PPI -size $(($N_WIDTH-2))x$N_HEIGHT \
   -borderColor black -border 1x1 \
   xc:$OTHER_COLOR \
   -gravity northwest -geometry +1+1 tmp_1.png -composite \
   $N_OUTPUT
fi
}

create_move_honor() {
M_TEMPLATE=$1
M_OUTPUT=$2
M_WIDTH=$3

M_MOVE=`cat $M_TEMPLATE | egrep '^Move' | cut -d: -f2-100`
M_HONOR=`cat $M_TEMPLATE | egrep '^Honor' | cut -d: -f2-100`

echo "Creating Move and Honour Section."

convert -density $PPI -size $(($M_WIDTH-2))x \
   -background $OTHER_COLOR -borderColor black -border 1x1 \
   -gravity west -font $MOVE_HONOR_FONT -fill $NOTE_COLOR -pointsize \
   $MOVE_HONOR_FONT_SIZE caption:"$M_MOVE" \
   -background none -gravity east -geometry +5+0 caption:"Honours: $M_HONOR" -composite \
    $M_OUTPUT
}

# Given a template file, create the damage box
create_dmg() {
D_TEMPLATE=$1
D_OUTPUT=$2
D_WIDTH=$3
D_HEIGHT=$4

echo "Creating Damage Boxes."

# Start by creating the critical box
CRIT_LINE=`cat $D_TEMPLATE | egrep "^Critical" | cut -d: -f2-100`
CRIT_NBOX=`echo $CRIT_LINE | cut -d\| -f 1`
CRIT_TITLE=`echo $CRIT_LINE | cut -d\| -f 2`
CRIT_SAVE=`echo $CRIT_LINE | cut -d\| -f 3`
CRIT_NOTES=`echo $CRIT_LINE | cut -d\| -f 4`

critical_box tmp_crit.png $D_WIDTH $CRIT_NBOX "$CRIT_TITLE"  "$CRIT_SAVE" "$CRIT_NOTES"

# Next calculate how much height is left
#CRIT_HEIGHT=`identify tmp_crit.png | nawk '{print $3}' | nawk -Fx '{print $2}'`
CRIT_HEIGHT=`img_height tmp_crit.png`
HEIGHT_LEFT=$(($D_HEIGHT - $CRIT_HEIGHT))

# Now make the high center low bar
HCL_LINE=`cat $D_TEMPLATE | egrep "^HighCenterLow" | cut -d: -f2-100`
if [ "$HCL_LINE" != "none" ] ; then
  HCL_HC=`echo $HCL_LINE | cut -d\| -f 1`
  HCL_CL=`echo $HCL_LINE | cut -d\| -f 2`
  HCL_X_HC=$(((($HEIGHT_LEFT)*$HCL_HC)/100))
  HCL_X_CL=$(((($HEIGHT_LEFT)*$HCL_CL)/100))
  convert -size 1x1 xc:$DMG_HCL_FONT_COLOR tmp_bar.png
  convert -background $DMG_HCL_COLOR -size $((${HCL_X_HC}-1))x -gravity center \
    -density $PPI -font $DMG_HCL_FONT -pointsize $DMG_HCL_FONT_SIZE -fill \
    $DMG_HCL_FONT_COLOR caption:"High" tmp_high.png
  if [ $HCL_X_HC -ne $HCL_X_CL ] ; then 
    convert -background $DMG_HCL_COLOR -size $(($HCL_X_CL - $HCL_X_HC))x \
      -density $PPI -font $DMG_HCL_FONT -pointsize $DMG_HCL_FONT_SIZE -fill \
      $DMG_HCL_FONT_COLOR caption:"Center" tmp_center.png
  else
    HCL_X_CL=$(($HCL_X_CL+1))
    convert -size 1x1  xc:$DMG_HCL_FONT_COLOR tmp_center.png
  fi
  convert -background $DMG_HCL_COLOR -size $(($HEIGHT_LEFT-1 - $HCL_X_CL))x \
    -gravity center \
    -density $PPI -font $DMG_HCL_FONT -pointsize $DMG_HCL_FONT_SIZE -fill \
    $DMG_HCL_FONT_COLOR caption:"Low" tmp_low.png

  convert -size ${HEIGHT_LEFT}x -background $DMG_HCL_FONT_COLOR \
    tmp_high.png tmp_bar.png tmp_center.png tmp_bar.png tmp_low.png +append \
    tmp_hcl.png

  D_WIDTH=$(($D_WIDTH-`img_height tmp_hcl.png`))
  convert tmp_hcl.png -rotate 90 tmp_hcl.png
fi

# Now create a working area for the height that's left
convert -size $(($D_WIDTH-2))x$(($HEIGHT_LEFT-2)) xc:$DMG_COLOR tmp_work.png
convert -border 1x1 -borderColor black tmp_work.png tmp_work.png

if [ "$HCL_LINE" != "none" ] ; then
  convert tmp_work.png tmp_hcl.png +append tmp_work.png
fi 
  

# Append on the critical
convert tmp_work.png tmp_crit.png -append $D_OUTPUT

# Now start creating damage boxes and sticking them onto our output

cat $D_TEMPLATE | egrep "^Dmg" | cut -d: -f2-100 | \
while read DMG_LINE
do
# x%|y%|end_x%|end_y%|num|boxes|title|save|notes
  DMG_X=$(((`echo $DMG_LINE | cut -d\| -f 1`*$D_WIDTH)/100))
  DMG_Y=$(((`echo $DMG_LINE | cut -d\| -f 2`*$HEIGHT_LEFT)/100))
  DMG_WIDTH=$(((`echo $DMG_LINE | cut -d\| -f 3`*$D_WIDTH)/100 - $DMG_X))
  DMG_HEIGHT=$(((`echo $DMG_LINE | cut -d\| -f 4`*$HEIGHT_LEFT)/100 - $DMG_Y))
  DMG_NUM=`echo $DMG_LINE | cut -d\| -f 5`
  DMG_BOX=`echo $DMG_LINE | cut -d\| -f 6`
  DMG_TITLE=`echo $DMG_LINE | cut -d\| -f 7`
  DMG_SAVE=`echo $DMG_LINE | cut -d\| -f 8`
  DMG_NOTES=`echo $DMG_LINE | cut -d\| -f 9`

  dmg_box tmp_dmg.png $DMG_WIDTH $DMG_HEIGHT "$DMG_NUM" $DMG_BOX "$DMG_TITLE" "$DMG_SAVE" "$DMG_NOTES"
  convert $D_OUTPUT tmp_dmg.png -geometry +${DMG_X}+${DMG_Y} -composite $D_OUTPUT
done
}

### Create a critical box
# height will be determined by the amount of space it takes
critical_box() {
# A critical box looks like
# Name
# Save
# Damage Boxes
# Description

OUTPUT=$1
WIDTH=$2
NBOX=$3
NAME=$4
SAVE=$5
DESC=$6

### Create the damage boxes
SB_HEIGHT=`small_boxes tmp_3.png $WIDTH $NBOX true`

convert -density $PPI -pointsize $DMG_TITLE_FONT_SIZE \
  -background none -size $((${WIDTH}-2))x \
  -fill $DMG_TITLE_COLOR -font $DMG_TITLE_FONT \
  caption:"$NAME" tmp_1.png

if [ -z "$SAVE" ] ; then 
 convert -size 1x1 xc:none tmp_2.png
else
 convert -density $PPI -pointsize $DMG_SAVE_FONT_SIZE \
  -background none -size $((${WIDTH}-2))x \
  -fill $DMG_SAVE_COLOR -font $DMG_SAVE_FONT caption:"$SAVE" tmp_2.png
fi 

if [ -z "$DESC" ] ; then
 convert -size 1x1 xc:none tmp_4.png
else
 convert -density $PPI -pointsize $DMG_NOTE_FONT_SIZE \
  -background none -size $((${WIDTH}-2))x \
  -fill $DMG_NOTE_COLOR -font $DMG_NOTE_FONT caption:"$DESC" tmp_4.png
fi

ONE_Y=0
TWO_Y=$((`img_height tmp_1.png`))
THREE_Y=$(($TWO_Y+`img_height tmp_2.png`))
FOUR_Y=$(($THREE_Y+$SB_HEIGHT))
FIVE_Y=$(($FOUR_Y+`img_height tmp_4.png`))
convert -size $((${WIDTH}-2))x${FIVE_Y} xc:none \
  tmp_1.png -geometry +0+0 -composite \
  tmp_2.png -geometry +0+$TWO_Y -composite \
  tmp_3.png -geometry +0+$THREE_Y -composite \
  tmp_4.png -geometry +0+$FOUR_Y -composite \
  $OUTPUT

convert -size `identify $OUTPUT | nawk '{print $3'}` xc:$CRITICAL_COLOR \
  $OUTPUT -composite $OUTPUT
convert -border 1x1 -borderColor black $OUTPUT $OUTPUT
}

dmg_box() {
# A damage box looks like
# Name
# Save
# Damage Boxes
# Description

OUTPUT=$1
WIDTH=$2
HEIGHT=$3
NUM=$4
NBOX=$5
NAME=$6
SAVE=$7
DESC=$8

SB_HEIGHT=`small_boxes tmp_3.png $WIDTH $NBOX true`

convert -density $PPI -pointsize 9 -background none -size $((${WIDTH}-2))x \
  -fill black -font $DMG_TITLE_FONT caption:"$NAME" tmp_1.png 
if [ -z "$SAVE" ] ; then
 convert -size 1x1 xc:none tmp_2.png
else
 convert -density $PPI -pointsize 7 -background none -size $((${WIDTH}-2))x \
  -fill black -font $DMG_SAVE_FONT caption:"$SAVE" tmp_2.png
fi
if [ -z "$DESC" ] ; then
 convert -size 1x1 xc:none tmp_4.png
else
 convert -density $PPI -pointsize 7 -background none -size $((${WIDTH}-2))x \
  -fill black -font $DMG_NOTE_FONT caption:"$DESC" tmp_4.png
fi

ONE_Y=0
TWO_Y=$((`img_height tmp_1.png`))
THREE_Y=$(($TWO_Y+`img_height tmp_2.png`))
FOUR_Y=$(($THREE_Y+$SB_HEIGHT))
FIVE_Y=$(($FOUR_Y+`img_height tmp_4.png`))
convert -size $(($WIDTH-2))x${FIVE_Y} xc:none \
  tmp_1.png -geometry +0+0 -composite \
  tmp_2.png -geometry +0+$TWO_Y -composite \
  tmp_3.png -geometry +0+$THREE_Y -composite \
  tmp_4.png -geometry +0+$FOUR_Y -composite \
  tmp_overlay.png 

convert -density $PPI -size $((${WIDTH}-2))x$((${HEIGHT}-2)) -pointsize 40 \
  -border 1x1 -borderColor black -background $DMG_COLOR -fill darkgray \
  -gravity northeast caption:"$NUM" $OUTPUT
convert $OUTPUT tmp_overlay.png -geometry +2+2 -composite $OUTPUT
}

###### Main

BASENAME=`basename $0`
USAGE="usage: $BASENAME [ -v <variable_file> ] [ -s <image_file> ] [ -i <id_txt> ] [ -n <additional_note> ] <template_file> <output_file>"

# The default globals file is always loaded
source `dirname $0`/globals.sh

SPECIFIER_ID_TXT="none"
NOTE_ADD="none"
KEEP_TMP="false"

while getopts ":v:s:i:n:k" options; do
  case $options in
    v ) source $OPTARG;;
    s ) SPECIFIER_IMG_FILE=$OPTARG;;
    i ) SPECIFIER_ID_TXT="$OPTARG";;
    n ) NOTE_ADD="$OPTARG";;
    k ) KEEP_TMP="true";;
    h ) echo $USAGE;;
    \? ) echo $USAGE
         exit 1;;
    * ) echo $USAGE
          exit 1;;
  esac
done

shift $(($OPTIND - 1))

if [ $# -ne 2 ] ; then
  echo $USAGE
  exit 1
fi

# Set the filename
TEMPLATE=$1
OUT=$2

USED=$(($PBORDER*2))
create_title $TEMPLATE tmp_t.png $POUTER_WIDTH "$SPECIFIER_IMG_FILE" "$SPECIFIER_ID_TXT"
USED=$((`img_height tmp_t.png`+$USED + $PBORDER))
NT=`total_note $TEMPLATE "$NOTE_ADD"`
create_note $TEMPLATE tmp_n.png $POUTER_WIDTH "$NOTE_ADD"
USED=$((`img_height tmp_n.png`+$USED + $PBORDER))
# If there is no note, it still creates a transparent 1x1 image
# But I don't want the border printed twice
if [ -z "$NT" ] ; then
  USED=$(($USED - $PBORDER))
fi
create_move_honor $TEMPLATE tmp_m.png $POUTER_WIDTH
USED=$((`img_height tmp_m.png`+$USED + $PBORDER))
# Need to calculate the final height
create_dmg $TEMPLATE tmp_d.png $POUTER_WIDTH $(($PHEIGHT-$USED))
# Calculate Y values
T_Y=${PBORDER}
D_Y=$((`img_height tmp_t.png` + $T_Y + $PBORDER))
N_Y=$((`img_height tmp_d.png` + $D_Y + $PBORDER))
M_Y=$((`img_height tmp_n.png` + $N_Y + $PBORDER))
if [ -z "$NT" ] ; then
  M_Y=$(($M_Y - $PBORDER))
fi
echo "Assembling final card image."
# Need to put together the final image
shadowfy tmp_t.png
shadowfy tmp_n.png
shadowfy tmp_d.png
shadowfy tmp_m.png 
convert -size ${PWIDTH}x${PHEIGHT} xc:$OUTER_COLOR \
   tmp_t.png -geometry +${PBORDER}+$T_Y -composite \
   tmp_d.png -geometry +${PBORDER}+$D_Y -composite \
   tmp_n.png -geometry +${PBORDER}+$N_Y -composite \
   tmp_m.png -geometry +${PBORDER}+$M_Y -composite \
   ${OUT}

if [ "$KEEP_TMP" != "true" ] ; then
  echo "Cleaning up temporary files."
  rm tmp*.png
fi

exit 1
