# This file is the globals definition file
# If you want to change the colors, fonts or sizes used
# this is where it's done

#### Sheet size
# How many cards can go on a sheet
# Note: you probably shouldn't have more than this number
# in your sheet file
SHEET_SIZE=3x3

#### Resolution
# The Pixels per Inch of the resulting image.
# 72 ppi is a common display image, 300 is a common print image.
#PPI=72
#PPI=100
PPI=220

#### Measurements
# All measurements are in 100ths of an inch, except font size which is in
# 72ths of an inch.

# Height and Width of the card
HEIGHT=350
WIDTH=250

# The size of a small box (i.e. a damage box or a crew box, typically for
# checking something off)
SBOX=12
# The size of a large box 
LBOX=50
# The size of the border around the outermost areas of the card
BORDER=8

#### Colors (note: Font colors are embedded in the font section)
# Background Colors 
OUTER_COLOR=red
DMG_COLOR=powderblue
CRITICAL_COLOR=skyblue
SBOX_COLOR=khaki
OTHER_COLOR=khaki

#### Font Colors
# All font sizes are scaled, assuming 72 ppi is the default 
# (so a font of size 72 has a size of 1 inch on a 72 PPI screen,
#  if you set PPI to 300, it is still 1 inch).

# The font size of these 3 fonts should be LBOX size in inches
# (so if LBOX is 50 (1/2") then they should add upto 36 (1/2")
# I know it's a bit confusing, but it's alot easier to code it this way
FACTION_FONT=Helvetica
FACTION_FONT_SIZE=9
FACTION_COLOR=yellow
TITLE_FONT=Helvetica
TITLE_FONT_SIZE=18
TITLE_COLOR=yellow
TYPE_FONT=Helvetica
TYPE_FONT_SIZE=9
TYPE_COLOR=yellow

# Once more, should be less than the LBOX size in inches
SPECIFIER_FONT=Helvetica
SPECIFIER_FONT_SIZE=32
SPECIFIER_COLOR=darkgrey
# The image to use under the specifier box
SPECIFIER_IMG_FILE=none

# Once more, should be less than the LBOX size in inches
CREW_FONT=Helvetica
CREW_FONT_SIZE=9
CREW_COLOR=yellow

NOTE_FONT=Helvetica
NOTE_FONT_SIZE=6
NOTE_COLOR=black
NOTE_HIGHLIGHT_FONT=Helvetica-Bold
NOTE_HIGHLIGHT_FONT_SIZE=7
NOTE_HIGHLIGHT_COLOR=black

MOVE_HONOR_FONT=Helvetica-Bold
MOVE_HONOR_FONT_SIZE=9
MOVE_HONOR_COLOR=black

DMG_TITLE_FONT=Helvetica-Bold
DMG_TITLE_FONT_SIZE=9
DMG_TITLE_COLOR=black
DMG_SAVE_FONT=Helvetica-BoldOblique
DMG_SAVE_FONT_SIZE=7
DMG_SAVE_COLOR=black
DMG_NOTE_FONT=Helvetica
DMG_NOTE_FONT_SIZE=7
DMG_NOTE_COLOR=black
DMG_UNDERLAY_FONT=Times-Roman
DMG_UNDERLAY_FONT_SIZE=32
DMG_UNDERLAY_COLOR=darkgrey
DMG_HCL_FONT=Helvetica
DMG_HCL_FONT_SIZE=7
DMG_HCL_FONT_COLOR=white
DMG_HCL_COLOR=black

#### Derived 
# Some derived global stats, most are the size in pixels of various things
PWIDTH=$((($WIDTH * $PPI)/100))
PHEIGHT=$((($HEIGHT * $PPI)/100))
PSBOX=$((($SBOX * $PPI)/100))
PLBOX=$((($LBOX * $PPI)/100))
PBORDER=$((($BORDER * $PPI)/100))
POUTER_WIDTH=$(($PWIDTH - $PBORDER * 2))
